/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.uddi;

import filenet.vw.base.VWDebug;
import filenet.vw.base.VWUDDIBusinessEntity;
import filenet.vw.base.VWUDDIRegistry;
import filenet.vw.base.VWUDDIRegistryList;
import filenet.vw.toolkit.admin.images.VWImageLoader;
import filenet.vw.toolkit.admin.property.uddi.VWConfigBusinessPublishInfoTableModel;
import filenet.vw.toolkit.admin.property.uddi.VWUDDIRegistryNameCellEditor;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.table.VWTableCellEditor;
import filenet.vw.toolkit.utils.table.VWTableCellRenderer;
import filenet.vw.toolkit.utils.table.VWTableHeaderRenderer;
import filenet.vw.toolkit.utils.table.VWToolTipTableCellRenderer;
import filenet.vw.toolkit.utils.uicontrols.border.IVWToolbarBorderActionListener;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderActionEvent;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderClientActionEvent;
import filenet.vw.toolkit.utils.ws.IVWUDDIPanelOperation;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;

public class VWConfigBusinessPublishInfoPanel
extends JPanel
implements TableModelListener,
ListSelectionListener,
IVWToolbarBorderActionListener,
IVWUDDIPanelOperation {
    private VWUDDIRegistryList m_uddiRegistryList = null;
    private JDialog m_parentDialog = null;
    private boolean m_bChanged = false;
    private VWToolbarBorder m_toolBarBorder = null;
    private VWTable m_UDDIRegistriesTable = null;
    private VWConfigBusinessPublishInfoTableModel m_tableModel = null;

    public VWConfigBusinessPublishInfoPanel(JDialog parentDialog, VWUDDIRegistryList uddiRegistryList) {
        try {
            this.m_parentDialog = parentDialog;
            this.m_uddiRegistryList = uddiRegistryList;
            this.createControls(parentDialog);
            this.setUDDIRegistryCellEditor();
            this.m_UDDIRegistriesTable.clearSelection();
            if (this.m_UDDIRegistriesTable.getRowCount() > 0) {
                this.m_UDDIRegistriesTable.setRowSelectionInterval(0, 0);
            } else {
                this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 2, 0x10000000));
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public boolean hasChanged() {
        this.stopEditing();
        return this.m_tableModel.hasChanged();
    }

    public boolean update() {
        boolean bSuccess = true;
        try {
            VWUDDIRegistry[] uddiRegistryArray;
            if (this.hasChanged() && (bSuccess = this.m_tableModel.verifyBusinessEntities()) && (uddiRegistryArray = this.m_uddiRegistryList.getUDDIRegistries()) != null && uddiRegistryArray.length > 0) {
                int sz = uddiRegistryArray.length;
                VWUDDIBusinessEntity[] businessEntityArray = this.m_tableModel.getVWBusinessEntities();
                for (int i = 0; i < sz; ++i) {
                    if (!uddiRegistryArray[i].isPublishable()) continue;
                    uddiRegistryArray[i].removeAllBusiness();
                    String uddiName = uddiRegistryArray[i].getName();
                    if (businessEntityArray == null || businessEntityArray.length <= 0) continue;
                    int len = businessEntityArray.length;
                    for (int j = 0; j < len; ++j) {
                        if (uddiName.compareTo(businessEntityArray[j].getUDDIRegistry()) != 0) continue;
                        uddiRegistryArray[i].addBusinessEntity(businessEntityArray[j]);
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_parentDialog, ex.getLocalizedMessage(), VWResource.ErrorMessage, 1);
        }
        return bSuccess;
    }

    public void tableChanged(TableModelEvent event) {
        switch (event.getType()) {
            case -1: 
            case 1: {
                if (this.m_UDDIRegistriesTable.getRowCount() <= 0) break;
                int nRow = event.getLastRow() - 1;
                if (nRow < 0) {
                    nRow = 0;
                }
                if (nRow == this.m_UDDIRegistriesTable.getSelectedRow()) {
                    this.m_UDDIRegistriesTable.clearSelection();
                }
                this.m_UDDIRegistriesTable.setRowSelectionInterval(nRow, nRow);
                this.m_UDDIRegistriesTable.ensureRowIsVisible(nRow);
            }
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        if (!event.getValueIsAdjusting()) {
            int nFirstIndex = this.m_UDDIRegistriesTable.getSelectionModel().getMinSelectionIndex();
            int nLastIndex = this.m_UDDIRegistriesTable.getSelectionModel().getMaxSelectionIndex();
            if (nFirstIndex < 0 || nLastIndex < 0) {
                this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 2, 0x10000000));
            } else {
                this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 1, 0x10000000));
            }
        }
    }

    public void toolbarBorderActionPerformed(VWToolbarBorderActionEvent event) {
        try {
            switch (event.getID()) {
                case 16: {
                    this.stopEditing();
                    int nRow = this.m_tableModel.getRowCount();
                    this.m_tableModel.addRow();
                    this.m_UDDIRegistriesTable.setRowSelectionInterval(nRow, nRow);
                    this.m_UDDIRegistriesTable.setColumnSelectionInterval(0, 0);
                    this.m_UDDIRegistriesTable.ensureRowIsVisible(nRow);
                    break;
                }
                case 0x10000000: {
                    this.onDeleteRows();
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void setUDDIRegistryCellEditor() {
        TableColumn tcElement = this.m_UDDIRegistriesTable.getColumnModel().getColumn(1);
        if (tcElement != null) {
            VWUDDIRegistryNameCellEditor rgNameEditor = new VWUDDIRegistryNameCellEditor(this.m_uddiRegistryList.getPublishableUDDIRegistries());
            tcElement.setCellEditor(rgNameEditor);
        }
    }

    public void createControls(JDialog parentDialog) {
        try {
            this.setBorder(new EmptyBorder(5, 5, 5, 5));
            this.setLayout(new BorderLayout(4, 4));
            this.createUDDIRegistriesPanel(parentDialog);
            this.add((Component)this.m_toolBarBorder, "Center");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void releaseResources() {
        if (this.m_uddiRegistryList != null) {
            this.m_uddiRegistryList.releaseResources();
            this.m_uddiRegistryList = null;
        }
        this.m_parentDialog = null;
        if (this.m_toolBarBorder != null) {
            this.m_toolBarBorder.releaseReferences();
            this.m_toolBarBorder = null;
        }
        if (this.m_UDDIRegistriesTable != null) {
            this.m_UDDIRegistriesTable.removeAll();
            this.m_UDDIRegistriesTable = null;
        }
        if (this.m_tableModel != null) {
            this.m_tableModel.releaseResources();
            this.m_tableModel = null;
        }
        this.removeAll();
    }

    public void resetTableModel() {
        this.m_tableModel = new VWConfigBusinessPublishInfoTableModel(this.m_parentDialog, this.m_uddiRegistryList);
    }

    private void createUDDIRegistriesPanel(JDialog parentDialog) {
        try {
            this.m_toolBarBorder = new VWToolbarBorder(VWResource.BusinessPublishInfo, 0x10000010);
            this.m_toolBarBorder.addToolbarBorderActionNotifier(this);
            this.m_tableModel = new VWConfigBusinessPublishInfoTableModel(parentDialog, this.m_uddiRegistryList);
            this.m_tableModel.addTableModelListener(this);
            this.m_UDDIRegistriesTable = new VWTable(this.m_tableModel);
            this.m_UDDIRegistriesTable.setRowSelectionAllowed(true);
            this.m_UDDIRegistriesTable.getSelectionModel().addListSelectionListener(this);
            this.m_UDDIRegistriesTable.setDefaultRenderer(String.class, new VWTableCellRenderer());
            this.m_UDDIRegistriesTable.setDefaultEditor(String.class, new VWTableCellEditor(new JTextField()));
            TableColumn tcElement = this.m_UDDIRegistriesTable.getColumn(this.m_tableModel.getColumnName(2));
            if (tcElement != null) {
                tcElement.setMaxWidth(20);
                tcElement.setHeaderRenderer(new VWTableHeaderRenderer(VWImageLoader.createImageIcon("publish_16.gif"), VWResource.Publish));
            }
            if ((tcElement = this.m_UDDIRegistriesTable.getColumn(this.m_tableModel.getColumnName(3))) != null) {
                tcElement.setCellRenderer(new VWToolTipTableCellRenderer());
            }
            if ((tcElement = this.m_UDDIRegistriesTable.getColumn(this.m_tableModel.getColumnName(5))) != null) {
                tcElement.setCellRenderer(new VWToolTipTableCellRenderer());
            }
            JPanel panel = this.m_toolBarBorder.getClientPanel();
            panel.setLayout(new BorderLayout());
            panel.add((Component)new JScrollPane(this.m_UDDIRegistriesTable), "Center");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onDeleteRows() {
        boolean bYesToAll = false;
        try {
            this.stopEditing();
            int[] rows = this.m_UDDIRegistriesTable.getSelectedRows();
            for (int nIndex = rows.length - 1; nIndex >= 0; --nIndex) {
                this.m_tableModel.removeRow(rows[nIndex]);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void stopEditing() {
        if (this.m_UDDIRegistriesTable != null) {
            this.m_UDDIRegistriesTable.stopEditing();
        }
    }

    public boolean validateData() {
        this.stopEditing();
        return this.m_tableModel.verifyBusinessEntities();
    }
}

